<?php 
require_once 'includes/config.php';
include 'includes/header.php';
include 'includes/sidebar.php';

// Cek jika user belum login
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

?>

<title>Dashboard - Miracle-TECH Phone Call System</title>

<div class="content" id="content">
    <div class="container-fluid">
        <h1 class="h3 mb-4">Dashboard</h1>

        <?php if (isset($_SESSION['success'])): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <?php 
                echo $_SESSION['success'];
                unset($_SESSION['success']);
                ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <?php if (isset($_SESSION['error'])): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <?php 
                echo $_SESSION['error'];
                unset($_SESSION['error']);
                ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <!-- Get filter values -->
        <?php
        $filters = [
            'action' => $_GET['action'] ?? '',
            'marketing_id' => $_GET['marketing'] ?? '',
            'date_from' => $_GET['date_from'] ?? '',
            'date_to' => $_GET['date_to'] ?? ''
        ];

        // Get marketing data
        $allData = getMarketingData($filters);

        // Paginasi
        $page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
        $perPage = 10;
        $paginationResult = paginateData($allData, $page, $perPage);

        $marketingData = $paginationResult['data'];
        $totalData = $paginationResult['total_data'];
        $totalPages = $paginationResult['total_pages'];
        $currentPage = $paginationResult['current_page'];

        // Get all marketing for dropdown
        $allMarketing = getAllMarketing();
        ?>

        <div class="card mb-3">
            <div class="card-body">
                <form class="row g-3" method="GET">
                    <div class="col-auto">
                        <label class="form-label">Action</label>
                        <select class="form-select form-select-sm" name="action">
                            <option value="">All Action</option>
                            <option value="Success" <?php echo $filters['action'] == 'Success' ? 'selected' : ''; ?>>Success</option>
                            <option value="Pending" <?php echo $filters['action'] == 'Pending' ? 'selected' : ''; ?>>Pending</option>
                        </select>
                    </div>
                    <div class="col-auto">
                        <label class="form-label">Marketing</label>
                        <select class="form-select form-select-sm select2-marketing" name="marketing">
                            <option value="">All Marketings</option>
                            <?php foreach($allMarketing as $mkt): ?>
                                <option value="<?php echo $mkt['id']; ?>" <?php echo $filters['marketing_id'] == $mkt['id'] ? 'selected' : ''; ?>>
                                    <?php echo htmlspecialchars($mkt['nama_lengkap']); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-auto">
                        <label class="form-label">Date From</label>
                        <input type="date" 
                               name="date_from" 
                               class="form-control form-control-sm" 
                               value="<?php echo $filters['date_from']; ?>"
                               placeholder="dd/mm/yyyy"
                               style="color: #666; min-width: 150px;">
                    </div>
                    <div class="col-auto">
                        <label class="form-label">Date To</label>
                        <input type="date" 
                               name="date_to" 
                               class="form-control form-control-sm" 
                               value="<?php echo $filters['date_to']; ?>"
                               placeholder="dd/mm/yyyy"
                               style="color: #666; min-width: 150px;">
                    </div>
                    <div class="col-auto d-flex align-items-end">
                        <button type="submit" class="btn btn-primary btn-sm">
                            <i class="fas fa-filter me-1"></i> Apply Filter
                        </button>
                        <a href="dashboard.php" class="btn btn-danger btn-sm ms-2">
                            <i class="fas fa-times me-1"></i> Clear Filter
                        </a>
                        <a href="export_report.php?<?php echo http_build_query($_GET); ?>" class="btn btn-success btn-sm ms-2">
                            <i class="fas fa-file-excel me-1"></i> Export .xlsx
                        </a>
                    </div>
                </form>
            </div>
        </div>

        <div class="card">
            <div class="card-body">
                <table class="table">
                    <thead>
                        <tr>
                            <th width="5%">No.</th>
                            <th width="15%" class="text-start">Target Number</th>
                            <th width="10%" class="sortable" onclick="sortTable('action')">
                                Action 
                                <i class="fas fa-sort ms-1"></i>
                            </th>
                            <th width="15%">Marketing</th>
                            <th width="35%">Note</th>
                            <th width="10%">Date</th>
                            <th width="10%" class="sortable" onclick="sortTable('nd')">
                                ND
                                <i class="fas fa-sort ms-1"></i>
                            </th>
                            <th width="10%">Edit</th>
                        </tr>
                    </thead>
                    <tbody id="tableBody">
                        <?php foreach($marketingData as $index => $data): ?>
                        <tr>
                            <td><?php echo $index + 1; ?></td>
                            <td class="text-start"><?php echo htmlspecialchars($data['phone_number']); ?></td>
                            <td data-action="<?php echo strtolower($data['status']); ?>">
                                <a href="https://wa.me/<?php echo preg_replace('/[^0-9]/', '', $data['phone_number']); ?>" 
                                   target="_blank" class="text-success">
                                    <i class="fab fa-whatsapp fa-lg"></i>
                                </a>
                                <span class="badge bg-<?php echo $data['status'] == 'Success' ? 'success' : 'danger'; ?>">
                                    FU
                                </span>
                            </td>
                            <td><?php echo htmlspecialchars(getMarketingName($data['marketing_id'])); ?></td>
                            <td><?php echo htmlspecialchars($data['note']); ?></td>
                            <td><?php echo date('d-M-Y', strtotime($data['original_call_date'])); ?></td>
                            <td data-nd="<?php echo $data['nd_status'] == 'active' ? 'yes' : 'no'; ?>">
                                <i class="fas fa-check-circle text-<?php echo $data['nd_status'] == 'active' ? 'success' : 'secondary'; ?>"></i>
                            </td>
                            <td>
                                <a href="#" class="text-primary" data-bs-toggle="modal" data-bs-target="#editNoteModal<?php echo $data['id']; ?>">
                                    <i class="fas fa-edit"></i>
                                </a>
                            </td>
                        </tr>
                        
                        <!-- Modal untuk setiap baris -->
                        <div class="modal fade" id="editNoteModal<?php echo $data['id']; ?>" tabindex="-1">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <form action="update_note.php" method="POST">
                                        <input type="hidden" name="id" value="<?php echo $data['id']; ?>">
                                        <input type="hidden" name="csrf_token" value="<?php echo generateCSRFToken(); ?>">
                                        
                                        <div class="modal-header">
                                            <h5 class="modal-title">Edit Note</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                        </div>
                                        <div class="modal-body">
                                            <div class="mb-3">
                                                <label class="form-label">Phone Number</label>
                                                <input type="text" class="form-control" value="<?php echo htmlspecialchars($data['phone_number']); ?>" readonly>
                                            </div>
                                            <div class="mb-3">
                                                <label for="noteText<?php echo $data['id']; ?>" class="form-label">Note</label>
                                                <textarea class="form-control" id="noteText<?php echo $data['id']; ?>" 
                                                          name="note" rows="3"><?php echo htmlspecialchars($data['note']); ?></textarea>
                                            </div>
                                            <div class="mb-3">
                                                <label class="form-label">ND Status</label>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="radio" name="nd_status" 
                                                           id="ndYes<?php echo $data['id']; ?>" value="active" 
                                                           <?php echo $data['nd_status'] == 'active' ? 'checked' : ''; ?>>
                                                    <label class="form-check-label" for="ndYes<?php echo $data['id']; ?>">Yes</label>
                                                </div>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="radio" name="nd_status" 
                                                           id="ndNo<?php echo $data['id']; ?>" value="inactive"
                                                           <?php echo $data['nd_status'] == 'inactive' ? 'checked' : ''; ?>>
                                                    <label class="form-check-label" for="ndNo<?php echo $data['id']; ?>">No</label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
                                            <button type="submit" class="btn btn-primary btn-sm">Save Changes</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </tbody>
                </table>
                
                <!-- Pagination -->
                <?php if ($totalPages > 1): ?>
                <div class="d-flex justify-content-between align-items-center mt-4">
                    <div class="text-muted">
                        Showing <?php echo ($currentPage - 1) * $perPage + 1; ?> to 
                        <?php echo min($currentPage * $perPage, $totalData); ?> of 
                        <?php echo $totalData; ?> entries
                    </div>
                    <nav aria-label="Page navigation">
                        <ul class="pagination pagination-sm mb-0">
                            <!-- Previous Button -->
                            <li class="page-item <?php echo $currentPage <= 1 ? 'disabled' : ''; ?>">
                                <a class="page-link" href="<?php 
                                    $queryParams = $_GET;
                                    $queryParams['page'] = $currentPage - 1;
                                    echo '?' . http_build_query($queryParams);
                                ?>" <?php echo $currentPage <= 1 ? 'tabindex="-1" aria-disabled="true"' : ''; ?>>
                                    Previous
                                </a>
                            </li>
                            
                            <!-- Page Numbers -->
                            <?php for ($i = max(1, $currentPage - 2); $i <= min($totalPages, $currentPage + 2); $i++): ?>
                                <li class="page-item <?php echo $currentPage == $i ? 'active' : ''; ?>">
                                    <a class="page-link" href="<?php 
                                        $queryParams = $_GET;
                                        $queryParams['page'] = $i;
                                        echo '?' . http_build_query($queryParams);
                                    ?>"><?php echo $i; ?></a>
                                </li>
                            <?php endfor; ?>
                            
                            <!-- Next Button -->
                            <li class="page-item <?php echo $currentPage >= $totalPages ? 'disabled' : ''; ?>">
                                <a class="page-link" href="<?php 
                                    $queryParams = $_GET;
                                    $queryParams['page'] = $currentPage + 1;
                                    echo '?' . http_build_query($queryParams);
                                ?>" <?php echo $currentPage >= $totalPages ? 'tabindex="-1" aria-disabled="true"' : ''; ?>>
                                    Next
                                </a>
                            </li>
                        </ul>
                    </nav>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Modal Edit Note -->
<div class="modal fade" id="editNoteModal1" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Edit Note</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label for="noteText1" class="form-label">Note</label>
                    <textarea class="form-control" id="noteText1" rows="3">Customer tertarik dengan produk</textarea>
                </div>
                <div class="mb-3">
                    <label class="form-label">ND</label>
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="nd1" id="ndYes1" value="yes" checked>
                        <label class="form-check-label" for="ndYes1">Yes</label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="nd1" id="ndNo1" value="no">
                        <label class="form-check-label" for="ndNo1">No</label>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary btn-sm">Save Changes</button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="editNoteModal2" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Edit Note</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label for="noteText2" class="form-label">Note</label>
                    <textarea class="form-control" id="noteText2" rows="3">Tidak tertarik dengan produk</textarea>
                </div>
                <div class="mb-3">
                    <label class="form-label">ND</label>
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="nd2" id="ndYes2" value="yes">
                        <label class="form-check-label" for="ndYes2">Yes</label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="nd2" id="ndNo2" value="no" checked>
                        <label class="form-check-label" for="ndNo2">No</label>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary btn-sm">Save Changes</button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="editNoteModal3" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Edit Note</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label for="noteText3" class="form-label">Note</label>
                    <textarea class="form-control" id="noteText3" rows="3">Minta informasi lebih detail</textarea>
                </div>
                <div class="mb-3">
                    <label class="form-label">ND</label>
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="nd3" id="ndYes3" value="yes" checked>
                        <label class="form-check-label" for="ndYes3">Yes</label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="nd3" id="ndNo3" value="no">
                        <label class="form-check-label" for="ndNo3">No</label>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary btn-sm">Save Changes</button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="editNoteModal4" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Edit Note</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label for="noteText4" class="form-label">Note</label>
                    <textarea class="form-control" id="noteText4" rows="3">Sudah menggunakan produk lain</textarea>
                </div>
                <div class="mb-3">
                    <label class="form-label">ND</label>
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="nd4" id="ndYes4" value="yes" checked>
                        <label class="form-check-label" for="ndYes4">Yes</label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="nd4" id="ndNo4" value="no">
                        <label class="form-check-label" for="ndNo4">No</label>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary btn-sm">Save Changes</button>
            </div>
        </div>
    </div>
</div>

<script>
// Initialize select2 for marketing dropdown
$(document).ready(function() {
    $('.select2-marketing').select2({
        width: '100%',
        placeholder: 'All Marketings',
        allowClear: true,
        minimumResultsForSearch: Infinity // Menyembunyikan search box
    });
});

let sortDirection = 1; // 1 for ascending, -1 for descending

function sortTable(column) {
    const tbody = document.getElementById('tableBody');
    const rows = Array.from(tbody.getElementsByTagName('tr'));
    
    // Toggle sort direction
    sortDirection *= -1;
    
    // Update sort icon
    const th = document.querySelector(`th[onclick="sortTable('${column}')"]`);
    const icon = th.querySelector('i');
    icon.className = sortDirection === 1 ? 'fas fa-sort-up ms-1' : 'fas fa-sort-down ms-1';
    
    // Sort rows
    rows.sort((a, b) => {
        let aValue, bValue;
        
        if (column === 'action') {
            aValue = a.querySelector(`td[data-action]`).getAttribute('data-action');
            bValue = b.querySelector(`td[data-action]`).getAttribute('data-action');
        } else if (column === 'nd') {
            aValue = a.querySelector(`td[data-nd]`).getAttribute('data-nd');
            bValue = b.querySelector(`td[data-nd]`).getAttribute('data-nd');
        }
        
        return aValue.localeCompare(bValue) * sortDirection;
    });
    
    // Reorder tbody
    rows.forEach(row => tbody.appendChild(row));
    
    // Update row numbers
    rows.forEach((row, index) => {
        row.querySelector('td:first-child').textContent = index + 1;
    });
}

// Add cursor pointer to sortable columns
document.addEventListener('DOMContentLoaded', function() {
    const sortableColumns = document.querySelectorAll('.sortable');
    sortableColumns.forEach(column => {
        column.style.cursor = 'pointer';
    });
});

// Format date inputs
document.addEventListener('DOMContentLoaded', function() {
    const dateInputs = document.querySelectorAll('input[type="date"]');
    dateInputs.forEach(input => {
        // Function to format date as DD/MM/YYYY
        function formatDate(date) {
            const parts = date.split('-');
            if (parts.length === 3) {
                const day = parts[2];
                const month = parts[1];
                const year = parts[0];
                return `${day}/${month}/${year}`;
            }
            return '';
        }
        
        // Clear initial value to show placeholder
        input.value = '';
        
        // Add event listener for date changes
        input.addEventListener('change', function(e) {
            const dateValue = this.value;
            if (dateValue) {
                const formattedDate = formatDate(dateValue);
                this.setAttribute('data-date', formattedDate);
            } else {
                this.setAttribute('data-date', '');
            }
        });
        
        // Format initial value
        input.dispatchEvent(new Event('change'));
    });
});
</script>

<?php include 'includes/footer.php'; ?> 